//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private AcuTraderPartnerEdition[] cacheAcuTraderPartnerEdition = null;

        private static AcuTraderPartnerEdition checkAcuTraderPartnerEdition = new AcuTraderPartnerEdition();

        /// <summary>
        /// Welcome to AcuTrader, for detailed instructions visit www.AcuTrader.com
        /// </summary>
        /// <returns></returns>
        public AcuTraderPartnerEdition AcuTraderPartnerEdition(Color areaColor, bool audioEnabled, bool audioIB, bool barCloseEnabled, bool barMarkersEnabled, bool barMarkersEnabledA, bool barPaintEnabled, bool barPaintEnabledA, int markerOffset, Color outlineColor, bool stopEnabled, bool stopEnabledA, Color textColor3, Font textFont, TextPosition tPos, bool trendEnabled, bool trendEnabledA, string wAVFileNameCL, string wAVFileNameCL2, string wAVFileNameCL3, string wAVFileNameCL4, int zopacity)
        {
            return AcuTraderPartnerEdition(Input, areaColor, audioEnabled, audioIB, barCloseEnabled, barMarkersEnabled, barMarkersEnabledA, barPaintEnabled, barPaintEnabledA, markerOffset, outlineColor, stopEnabled, stopEnabledA, textColor3, textFont, tPos, trendEnabled, trendEnabledA, wAVFileNameCL, wAVFileNameCL2, wAVFileNameCL3, wAVFileNameCL4, zopacity);
        }

        /// <summary>
        /// Welcome to AcuTrader, for detailed instructions visit www.AcuTrader.com
        /// </summary>
        /// <returns></returns>
        public AcuTraderPartnerEdition AcuTraderPartnerEdition(Data.IDataSeries input, Color areaColor, bool audioEnabled, bool audioIB, bool barCloseEnabled, bool barMarkersEnabled, bool barMarkersEnabledA, bool barPaintEnabled, bool barPaintEnabledA, int markerOffset, Color outlineColor, bool stopEnabled, bool stopEnabledA, Color textColor3, Font textFont, TextPosition tPos, bool trendEnabled, bool trendEnabledA, string wAVFileNameCL, string wAVFileNameCL2, string wAVFileNameCL3, string wAVFileNameCL4, int zopacity)
        {
            if (cacheAcuTraderPartnerEdition != null)
                for (int idx = 0; idx < cacheAcuTraderPartnerEdition.Length; idx++)
                    if (cacheAcuTraderPartnerEdition[idx].AreaColor == areaColor && cacheAcuTraderPartnerEdition[idx].AudioEnabled == audioEnabled && cacheAcuTraderPartnerEdition[idx].AudioIB == audioIB && cacheAcuTraderPartnerEdition[idx].BarCloseEnabled == barCloseEnabled && cacheAcuTraderPartnerEdition[idx].BarMarkersEnabled == barMarkersEnabled && cacheAcuTraderPartnerEdition[idx].BarMarkersEnabledA == barMarkersEnabledA && cacheAcuTraderPartnerEdition[idx].BarPaintEnabled == barPaintEnabled && cacheAcuTraderPartnerEdition[idx].BarPaintEnabledA == barPaintEnabledA && cacheAcuTraderPartnerEdition[idx].MarkerOffset == markerOffset && cacheAcuTraderPartnerEdition[idx].OutlineColor == outlineColor && cacheAcuTraderPartnerEdition[idx].StopEnabled == stopEnabled && cacheAcuTraderPartnerEdition[idx].StopEnabledA == stopEnabledA && cacheAcuTraderPartnerEdition[idx].TextColor3 == textColor3 && cacheAcuTraderPartnerEdition[idx].TextFont == textFont && cacheAcuTraderPartnerEdition[idx].TPos == tPos && cacheAcuTraderPartnerEdition[idx].TrendEnabled == trendEnabled && cacheAcuTraderPartnerEdition[idx].TrendEnabledA == trendEnabledA && cacheAcuTraderPartnerEdition[idx].WAVFileNameCL == wAVFileNameCL && cacheAcuTraderPartnerEdition[idx].WAVFileNameCL2 == wAVFileNameCL2 && cacheAcuTraderPartnerEdition[idx].WAVFileNameCL3 == wAVFileNameCL3 && cacheAcuTraderPartnerEdition[idx].WAVFileNameCL4 == wAVFileNameCL4 && cacheAcuTraderPartnerEdition[idx].Zopacity == zopacity && cacheAcuTraderPartnerEdition[idx].EqualsInput(input))
                        return cacheAcuTraderPartnerEdition[idx];

            lock (checkAcuTraderPartnerEdition)
            {
                checkAcuTraderPartnerEdition.AreaColor = areaColor;
                areaColor = checkAcuTraderPartnerEdition.AreaColor;
                checkAcuTraderPartnerEdition.AudioEnabled = audioEnabled;
                audioEnabled = checkAcuTraderPartnerEdition.AudioEnabled;
                checkAcuTraderPartnerEdition.AudioIB = audioIB;
                audioIB = checkAcuTraderPartnerEdition.AudioIB;
                checkAcuTraderPartnerEdition.BarCloseEnabled = barCloseEnabled;
                barCloseEnabled = checkAcuTraderPartnerEdition.BarCloseEnabled;
                checkAcuTraderPartnerEdition.BarMarkersEnabled = barMarkersEnabled;
                barMarkersEnabled = checkAcuTraderPartnerEdition.BarMarkersEnabled;
                checkAcuTraderPartnerEdition.BarMarkersEnabledA = barMarkersEnabledA;
                barMarkersEnabledA = checkAcuTraderPartnerEdition.BarMarkersEnabledA;
                checkAcuTraderPartnerEdition.BarPaintEnabled = barPaintEnabled;
                barPaintEnabled = checkAcuTraderPartnerEdition.BarPaintEnabled;
                checkAcuTraderPartnerEdition.BarPaintEnabledA = barPaintEnabledA;
                barPaintEnabledA = checkAcuTraderPartnerEdition.BarPaintEnabledA;
                checkAcuTraderPartnerEdition.MarkerOffset = markerOffset;
                markerOffset = checkAcuTraderPartnerEdition.MarkerOffset;
                checkAcuTraderPartnerEdition.OutlineColor = outlineColor;
                outlineColor = checkAcuTraderPartnerEdition.OutlineColor;
                checkAcuTraderPartnerEdition.StopEnabled = stopEnabled;
                stopEnabled = checkAcuTraderPartnerEdition.StopEnabled;
                checkAcuTraderPartnerEdition.StopEnabledA = stopEnabledA;
                stopEnabledA = checkAcuTraderPartnerEdition.StopEnabledA;
                checkAcuTraderPartnerEdition.TextColor3 = textColor3;
                textColor3 = checkAcuTraderPartnerEdition.TextColor3;
                checkAcuTraderPartnerEdition.TextFont = textFont;
                textFont = checkAcuTraderPartnerEdition.TextFont;
                checkAcuTraderPartnerEdition.TPos = tPos;
                tPos = checkAcuTraderPartnerEdition.TPos;
                checkAcuTraderPartnerEdition.TrendEnabled = trendEnabled;
                trendEnabled = checkAcuTraderPartnerEdition.TrendEnabled;
                checkAcuTraderPartnerEdition.TrendEnabledA = trendEnabledA;
                trendEnabledA = checkAcuTraderPartnerEdition.TrendEnabledA;
                checkAcuTraderPartnerEdition.WAVFileNameCL = wAVFileNameCL;
                wAVFileNameCL = checkAcuTraderPartnerEdition.WAVFileNameCL;
                checkAcuTraderPartnerEdition.WAVFileNameCL2 = wAVFileNameCL2;
                wAVFileNameCL2 = checkAcuTraderPartnerEdition.WAVFileNameCL2;
                checkAcuTraderPartnerEdition.WAVFileNameCL3 = wAVFileNameCL3;
                wAVFileNameCL3 = checkAcuTraderPartnerEdition.WAVFileNameCL3;
                checkAcuTraderPartnerEdition.WAVFileNameCL4 = wAVFileNameCL4;
                wAVFileNameCL4 = checkAcuTraderPartnerEdition.WAVFileNameCL4;
                checkAcuTraderPartnerEdition.Zopacity = zopacity;
                zopacity = checkAcuTraderPartnerEdition.Zopacity;

                if (cacheAcuTraderPartnerEdition != null)
                    for (int idx = 0; idx < cacheAcuTraderPartnerEdition.Length; idx++)
                        if (cacheAcuTraderPartnerEdition[idx].AreaColor == areaColor && cacheAcuTraderPartnerEdition[idx].AudioEnabled == audioEnabled && cacheAcuTraderPartnerEdition[idx].AudioIB == audioIB && cacheAcuTraderPartnerEdition[idx].BarCloseEnabled == barCloseEnabled && cacheAcuTraderPartnerEdition[idx].BarMarkersEnabled == barMarkersEnabled && cacheAcuTraderPartnerEdition[idx].BarMarkersEnabledA == barMarkersEnabledA && cacheAcuTraderPartnerEdition[idx].BarPaintEnabled == barPaintEnabled && cacheAcuTraderPartnerEdition[idx].BarPaintEnabledA == barPaintEnabledA && cacheAcuTraderPartnerEdition[idx].MarkerOffset == markerOffset && cacheAcuTraderPartnerEdition[idx].OutlineColor == outlineColor && cacheAcuTraderPartnerEdition[idx].StopEnabled == stopEnabled && cacheAcuTraderPartnerEdition[idx].StopEnabledA == stopEnabledA && cacheAcuTraderPartnerEdition[idx].TextColor3 == textColor3 && cacheAcuTraderPartnerEdition[idx].TextFont == textFont && cacheAcuTraderPartnerEdition[idx].TPos == tPos && cacheAcuTraderPartnerEdition[idx].TrendEnabled == trendEnabled && cacheAcuTraderPartnerEdition[idx].TrendEnabledA == trendEnabledA && cacheAcuTraderPartnerEdition[idx].WAVFileNameCL == wAVFileNameCL && cacheAcuTraderPartnerEdition[idx].WAVFileNameCL2 == wAVFileNameCL2 && cacheAcuTraderPartnerEdition[idx].WAVFileNameCL3 == wAVFileNameCL3 && cacheAcuTraderPartnerEdition[idx].WAVFileNameCL4 == wAVFileNameCL4 && cacheAcuTraderPartnerEdition[idx].Zopacity == zopacity && cacheAcuTraderPartnerEdition[idx].EqualsInput(input))
                            return cacheAcuTraderPartnerEdition[idx];

                AcuTraderPartnerEdition indicator = new AcuTraderPartnerEdition();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AreaColor = areaColor;
                indicator.AudioEnabled = audioEnabled;
                indicator.AudioIB = audioIB;
                indicator.BarCloseEnabled = barCloseEnabled;
                indicator.BarMarkersEnabled = barMarkersEnabled;
                indicator.BarMarkersEnabledA = barMarkersEnabledA;
                indicator.BarPaintEnabled = barPaintEnabled;
                indicator.BarPaintEnabledA = barPaintEnabledA;
                indicator.MarkerOffset = markerOffset;
                indicator.OutlineColor = outlineColor;
                indicator.StopEnabled = stopEnabled;
                indicator.StopEnabledA = stopEnabledA;
                indicator.TextColor3 = textColor3;
                indicator.TextFont = textFont;
                indicator.TPos = tPos;
                indicator.TrendEnabled = trendEnabled;
                indicator.TrendEnabledA = trendEnabledA;
                indicator.WAVFileNameCL = wAVFileNameCL;
                indicator.WAVFileNameCL2 = wAVFileNameCL2;
                indicator.WAVFileNameCL3 = wAVFileNameCL3;
                indicator.WAVFileNameCL4 = wAVFileNameCL4;
                indicator.Zopacity = zopacity;
                Indicators.Add(indicator);
                indicator.SetUp();

                AcuTraderPartnerEdition[] tmp = new AcuTraderPartnerEdition[cacheAcuTraderPartnerEdition == null ? 1 : cacheAcuTraderPartnerEdition.Length + 1];
                if (cacheAcuTraderPartnerEdition != null)
                    cacheAcuTraderPartnerEdition.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheAcuTraderPartnerEdition = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Welcome to AcuTrader, for detailed instructions visit www.AcuTrader.com
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcuTraderPartnerEdition AcuTraderPartnerEdition(Color areaColor, bool audioEnabled, bool audioIB, bool barCloseEnabled, bool barMarkersEnabled, bool barMarkersEnabledA, bool barPaintEnabled, bool barPaintEnabledA, int markerOffset, Color outlineColor, bool stopEnabled, bool stopEnabledA, Color textColor3, Font textFont, TextPosition tPos, bool trendEnabled, bool trendEnabledA, string wAVFileNameCL, string wAVFileNameCL2, string wAVFileNameCL3, string wAVFileNameCL4, int zopacity)
        {
            return _indicator.AcuTraderPartnerEdition(Input, areaColor, audioEnabled, audioIB, barCloseEnabled, barMarkersEnabled, barMarkersEnabledA, barPaintEnabled, barPaintEnabledA, markerOffset, outlineColor, stopEnabled, stopEnabledA, textColor3, textFont, tPos, trendEnabled, trendEnabledA, wAVFileNameCL, wAVFileNameCL2, wAVFileNameCL3, wAVFileNameCL4, zopacity);
        }

        /// <summary>
        /// Welcome to AcuTrader, for detailed instructions visit www.AcuTrader.com
        /// </summary>
        /// <returns></returns>
        public Indicator.AcuTraderPartnerEdition AcuTraderPartnerEdition(Data.IDataSeries input, Color areaColor, bool audioEnabled, bool audioIB, bool barCloseEnabled, bool barMarkersEnabled, bool barMarkersEnabledA, bool barPaintEnabled, bool barPaintEnabledA, int markerOffset, Color outlineColor, bool stopEnabled, bool stopEnabledA, Color textColor3, Font textFont, TextPosition tPos, bool trendEnabled, bool trendEnabledA, string wAVFileNameCL, string wAVFileNameCL2, string wAVFileNameCL3, string wAVFileNameCL4, int zopacity)
        {
            return _indicator.AcuTraderPartnerEdition(input, areaColor, audioEnabled, audioIB, barCloseEnabled, barMarkersEnabled, barMarkersEnabledA, barPaintEnabled, barPaintEnabledA, markerOffset, outlineColor, stopEnabled, stopEnabledA, textColor3, textFont, tPos, trendEnabled, trendEnabledA, wAVFileNameCL, wAVFileNameCL2, wAVFileNameCL3, wAVFileNameCL4, zopacity);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Welcome to AcuTrader, for detailed instructions visit www.AcuTrader.com
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcuTraderPartnerEdition AcuTraderPartnerEdition(Color areaColor, bool audioEnabled, bool audioIB, bool barCloseEnabled, bool barMarkersEnabled, bool barMarkersEnabledA, bool barPaintEnabled, bool barPaintEnabledA, int markerOffset, Color outlineColor, bool stopEnabled, bool stopEnabledA, Color textColor3, Font textFont, TextPosition tPos, bool trendEnabled, bool trendEnabledA, string wAVFileNameCL, string wAVFileNameCL2, string wAVFileNameCL3, string wAVFileNameCL4, int zopacity)
        {
            return _indicator.AcuTraderPartnerEdition(Input, areaColor, audioEnabled, audioIB, barCloseEnabled, barMarkersEnabled, barMarkersEnabledA, barPaintEnabled, barPaintEnabledA, markerOffset, outlineColor, stopEnabled, stopEnabledA, textColor3, textFont, tPos, trendEnabled, trendEnabledA, wAVFileNameCL, wAVFileNameCL2, wAVFileNameCL3, wAVFileNameCL4, zopacity);
        }

        /// <summary>
        /// Welcome to AcuTrader, for detailed instructions visit www.AcuTrader.com
        /// </summary>
        /// <returns></returns>
        public Indicator.AcuTraderPartnerEdition AcuTraderPartnerEdition(Data.IDataSeries input, Color areaColor, bool audioEnabled, bool audioIB, bool barCloseEnabled, bool barMarkersEnabled, bool barMarkersEnabledA, bool barPaintEnabled, bool barPaintEnabledA, int markerOffset, Color outlineColor, bool stopEnabled, bool stopEnabledA, Color textColor3, Font textFont, TextPosition tPos, bool trendEnabled, bool trendEnabledA, string wAVFileNameCL, string wAVFileNameCL2, string wAVFileNameCL3, string wAVFileNameCL4, int zopacity)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.AcuTraderPartnerEdition(input, areaColor, audioEnabled, audioIB, barCloseEnabled, barMarkersEnabled, barMarkersEnabledA, barPaintEnabled, barPaintEnabledA, markerOffset, outlineColor, stopEnabled, stopEnabledA, textColor3, textFont, tPos, trendEnabled, trendEnabledA, wAVFileNameCL, wAVFileNameCL2, wAVFileNameCL3, wAVFileNameCL4, zopacity);
        }
    }
}
#endregion
